import processing.opengl.*;

/* en tests : peu de cible sur écran pas trop grand
int numTargets = 5;
int screen_width = 800;
int screen_height = 600;
*/
// en production : 10 cibles sur grand écran
int numTargets = 10;
int screen_width = 1024;
int screen_height = 768;

int resultat = 0;

class Point
{
  int x;
  int y;

  Point(int x, int y) // centre d'une cible
  {
    this.x = x;
    this.y = y;
  }
}

class Target extends Point // la cible
{
  int radius;
  float clickTime;
  float distance;

  Target(int x, int y, int r)
  {
    super(x, y);
    this.radius = r;
    this.clickTime = 0.0;
    this.distance = 0.0;
  }

  void draw()
  {
    ellipse(x, y, radius*2, radius*2);
  }

  void drawTime()
  {
    text((int)this.clickTime, this.x, this.y);
  }

  void drawRadius()
  {
    text((int)this.radius, this.x, this.y);
  }

  void drawDistance()
  {
    text((int)this.distance, this.x, this.y);
  }

  void clicked(float time, int x, int y)
  {
    this.clickTime = time;
    this.distance = sqrt((this.x-x)*(this.x-x) + (this.y-y)*(this.y-y));
  }
}

int currentTarget = 0;

Target [] myTargets;

class Record
{
  float time;
  Point pos;
  int action;      // 0 = move, 1 = clic ok, 2 = clic wrong
  int target;
  Record next;

  Record(float t, int x, int y, int a, int target, Record n)
  {
    this.time = t;
    this.pos = new Point(x, y);
    this.action = a;
    this.target = target;
    this.next = n;
  }

  float getTime()
  {
    return time;
  }

  Record add(Record r)
  {
    this.next = r;
    return r;
  }

  void dump(String filename)
  {
    float d = 0;

    PrintWriter output = createWriter(filename); 

    output.println("Temps" + ";" + " x" + ";" + " y" + ";" + " action" + ";" + " target");
    for (Record rec = this; rec != null; rec=rec.next)
    {
      output.println(rec.time + ";" + rec.pos.x + ";" + rec.pos.y + ";" + rec.action + ";" + rec.target);
      if (rec.next != null)
      {
        d += sqrt(sq(rec.pos.x-rec.next.pos.x)+sq(rec.pos.y-rec.next.pos.y));
      }
    }

    output.println("total mouse distance = " + d);
    println("total mouse distance = " + d);

    output.flush();
    output.close();
  }

  void draw()
  {
    if (next != null)
    {
      line(pos.x, pos.y, next.pos.x, next.pos.y);
      next.draw();
    }
  }
}

Record firstRecord = null, lastRecord = null;

float startTime;      // Le temps système du début de simu
boolean finished = false;

int lastX = 0, lastY = 0;    // Sauvegarde des dernières coordonnées de clic valide

float getTime()       // Renvoie le temps écoulé depuis le début de la simu
{
  return millis()-startTime;
}

void createTargets()
{
  randomSeed((int)((float)second()*millis()));

  myTargets = new Target[numTargets];

  for (int i=0; i<numTargets; i++)
  {
    myTargets[i] = new Target((int)random(20, screen_width-20), 
    (int)random(20, screen_height-20), 
    (int)random(1, 4)*15);
  }
}

void setup() {
  size(screen_width, screen_height);
  background(255);

  createTargets();

  startTime = millis();
}

synchronized void record(int x, int y, int action)
{
  if (firstRecord == null)
  {
    firstRecord = new Record(getTime(), x, y, 0, currentTarget, null);
    lastRecord = firstRecord;
  }
  else
    lastRecord = lastRecord.add(new Record(getTime(), x, y, 0, currentTarget, null));
}

void draw() {

  background(0);

  if (!finished) // on affiche la cible
  {
    myTargets[currentTarget].draw();

    // Record 
    if (currentTarget>0)
      record(mouseX, mouseY, 0);
  }
  else
  {
    for (int i=0; i<numTargets;i++)
      myTargets[i].draw();

    stroke(255, 0, 0);
    firstRecord.draw();

    fill(32, 128, 128);
    PFont font;
    font = loadFont("Eureka90.vlw"); 
    textFont(font); 
    textSize(16);
    textAlign(CENTER, CENTER);

    for (int i=0; i<numTargets;i++) {
      if (resultat == 0)  myTargets[i].drawTime(); 
      else if (resultat == 1) myTargets[i].drawRadius(); 
      else  myTargets[i].drawDistance();
    }

    if (++resultat==3) resultat=0;

    fill(255, 255, 255);
  }
}

void mouseReleased() // MouseUp
{
  if (finished) 
  {
    redraw();
  }
  else {
    record(mouseX, mouseY, 1);

    int x = mouseX - myTargets[currentTarget].x;
    int y = mouseY - myTargets[currentTarget].y;

    if (sqrt(x*x+y*y) <= myTargets[currentTarget].radius)
    {
      // clic ok -> next target
      myTargets[currentTarget].clicked(getTime(), lastX, lastY);
      lastX = mouseX;
      lastY = mouseY;
      currentTarget++;

      // Finished ?
      if (currentTarget == numTargets)
      {
        finished = true;
        firstRecord.dump("mouse.txt");

        // dump target data
        PrintWriter output = createWriter("targets.txt"); 

        output.println("radius;time;distance"); 

        float d = 0.0;

        for (int i=1; i<numTargets; i++)
        {
          output.println(myTargets[i].radius + ";" + (myTargets[i].clickTime-myTargets[i-1].clickTime) + ";" + myTargets[i].distance); 

          d += myTargets[i].distance;
        }

        output.println("total target distance = " + d);

        output.flush();
        output.close();

        println("total target distance = " + d);

        noLoop();
      }
    }
    else 
    {
      // clic wrong :-(
      lastRecord.action = 2;
    }
  }
}

